<?php 
require_once $_SERVER['DOCUMENT_ROOT'].'/system/includes/AdminCheck.php';
?>

<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/2.0.0/css/dataTables.dataTables.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/3.0.0/css/buttons.dataTables.css">

<script src="https://code.jquery.com/jquery-3.7.1.js"></script>
<script src="https://cdn.datatables.net/2.0.0/js/dataTables.js"></script>
<script src="https://cdn.datatables.net/buttons/3.0.0/js/dataTables.buttons.js"></script>
<script src="https://cdn.datatables.net/buttons/3.0.0/js/buttons.dataTables.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/3.0.0/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/3.0.0/js/buttons.print.min.js"></script>

<?php 
if($_GET['order']) { 
    if(!empty($_GET['date1']) && !empty($_GET['date2'])) {

        $start_date = date('d-m-Y', strtotime($_GET['date1']));

        $end_date = date('d-m-Y', strtotime($_GET['date2']));
        
        $date1 = $start_date . ' 00:00:00';
        
        $date2 = $end_date . ' 23:59:59';
    } else {
        $date1 = $_GET['date1'];
        $date2 = $_GET['date2'];   
    }
}
?>

<?php if($_GET['order']){ ?>
<script type="text/javascript">
$(document).ready(function() {
    $('#orders').DataTable({
      dom: 'Bfrtip',
      "buttons": [
        'copy',
        'excel',
        'pdf',
        'print',
      ]
    });
  });

</script> 
    <table id="orders" class="display" style="width:100%">
        <thead style="background-color:#0047ab;color:white;">
            <tr>
            <th>ID</th>
        <th>Kategori</th>
        <th>Ürün</th>
        <th>Müşteri</th>
        <th>Fiyat</th>
        <th>Tarih</th>
        <th>Kalan Borç</th>
            </tr>
        </thead style="background-color:#0047ab;color:white;">
        <tbody>
        <?php 
        if(!empty($date1) && !empty($date2)){
        $sql = "SELECT * FROM orders WHERE orderDate BETWEEN :start_date AND :end_date ORDER BY id DESC";
        $query = $DB->prepare($sql);
        $query->bindParam(':start_date', $date1);
        $query->bindParam(':end_date', $date2);
        $query->execute();
        $orders = $query->fetchAll(PDO::FETCH_ASSOC);
        }else{
            $orders = $DB->query("
               SELECT 
                orders.id as order_id,
                GROUP_CONCAT(category.ad) as category_ad,
                orders.orderFiyat,
                orders.orderDate,
                orders.remainingDebt,
                GROUP_CONCAT(products.id) as product_ids,
                orders.memberID
            FROM 
                orders 
            INNER JOIN 
                products ON FIND_IN_SET(products.id, orders.products)
            INNER JOIN 
                category ON products.category = category.id
            GROUP BY 
                orders.id
            ORDER BY 
                orders.id DESC
        ")->fetchAll(PDO::FETCH_ASSOC);
        }
        foreach ($orders as $orderData) {
            $categoryID = $orderData['category'];
        
            $productIDs = explode(',', $orderData['product_ids']);
            $products = [];
            foreach ($productIDs as $productID) {
                $product = $DB->query("SELECT * FROM products WHERE id = '$productID'")->fetch(PDO::FETCH_ASSOC);
                $products[] = $product;
            }
        
            $memberID = $orderData['memberID'];
            $member = $DB->query("SELECT * FROM members WHERE id = '$memberID'")->fetch(PDO::FETCH_ASSOC);
        
            ?>
            <tr>
                <td><?=$orderData['order_id']?></td>
                <td><?=$orderData['category_ad']?></td>
                <td>
    <?php
    $productCount = count($products);
    foreach ($products as $index => $product):
        echo $product['ad'];
        if ($index < $productCount - 1) {
            echo ', ';
        }
    endforeach;
    ?><br>
</td>
                <td><?=$member['name']?></td>
                <td><?=$orderData['orderFiyat']?></td>
                <td><?=$orderData['orderDate']?></td>
                <td>
    <?php
    $remainingDebt = $orderData['remainingDebt'];
    $debtDisplay = ($remainingDebt < 0) ? substr($remainingDebt, 1) : $remainingDebt;
    $debtColor = ($remainingDebt < 0) ? 'green' : 'red';
    $debtSymbol = ($remainingDebt < 0) ? '' : '-';
    ?>
    <a style="color:<?=$debtColor?>">
        <?=$debtSymbol?><?=$debtDisplay?> ₺
    </a>
</td>
            </tr>
            <?php 
        }
        ?> 
</tbody>

<tfoot style="background-color:#0047ab;color:white;">
    <tr>
    <th>ID</th>
    <th>Kategori</th>
    <th>Ürün</th>
    <th>Müşteri</th>
    <th>Fiyat</th>
    <th>Tarih</th>
    <th>Kalan Borç</th>
    </tr>
</tfoot style="background-color:#0047ab;color:white;">
</table>
<?php } ?>

<?php 
if($_GET['case']) { 
    if(!empty($_GET['date1']) && !empty($_GET['date2'])) {

        $start_date = date('Y-m-d', strtotime($_GET['date1']));

        $end_date = date('Y-m-d', strtotime($_GET['date2']));
        
        $date1 = $start_date . ' 00:00:00';
        
        $date2 = $end_date . ' 23:59:59';
    } else {
        $date1 = $_GET['date1'];
        $date2 = $_GET['date2'];   
    }
}
?>

<?php if($_GET['case']){ ?>
<script type="text/javascript">
$(document).ready(function() {
    $('#case').DataTable({
      dom: 'Bfrtip',
      "buttons": [
        'copy',
        'excel',
        'pdf',
        'print',
      ]
    });
  });

</script> 
    <table id="case" class="display" style="width:100%">
        <thead style="background-color:#0047ab;color:white;">
            <tr>
            <th>ID</th>
            <th>Tarih</th>
            <th>Tutar</th>
            <th>Tür</th>
            <th>Açıklama</th>
            <th>Müşteri</th>
            </tr>
        </thead>
        <tbody>
        <?php 
        if(!empty($date1) && !empty($date2)){
            $sql = "SELECT * FROM business_case WHERE caseDate BETWEEN :start_date AND :end_date ORDER BY id DESC";
            $query = $DB->prepare($sql);
            $query->bindParam(':start_date', $date1);
            $query->bindParam(':end_date', $date2);
            $query->execute();
            $cases = $query->fetchAll(PDO::FETCH_ASSOC);
        } else {
            $cases = $DB->query("SELECT * from business_case order by id desc")->fetchAll(PDO::FETCH_ASSOC); 
        }
        foreach ($cases as $caseData) {       
            $memberID = $caseData['member'];
            $member = $DB->query("SELECT * FROM members WHERE id = '$memberID'")->fetch(PDO::FETCH_ASSOC);
        ?>
            <tr>
                <td><?=$caseData['id']?></td>
                <td><?= date("Y-m-d", strtotime($caseData['caseDate'])) ?></td>
                <td><?=$caseData['casePrice']?>₺</td>
                <td>
                    <?php if($caseData['caseType'] == '1') {
echo "<p style='color:green'>Gelir</p>";
} ?>
                    <?php if($caseData['caseType'] == '2') {
echo "<p style='color:red'>Gider</p>";
} ?>
                </td>
                <td><?=$caseData['caseNote']?></td>
                <td>
                    <?php
                    if (isset($caseData['member']) && $caseData['member']) {
                        $memberId = $caseData['member'];
                        $stmt = $DB->prepare("SELECT name FROM members WHERE id = ?");
                        $stmt->execute([$memberId]);
                        $member = $stmt->fetch(PDO::FETCH_ASSOC);
                        
                            echo $member['name'];
                           
                        }

                    ?>
                </td>
            </tr>
        <?php 
        }
        ?> 
        </tbody>
        <tfoot style="background-color:#0047ab;color:white;">
            <tr>
                <th>ID</th>
                <th>Tarih</th>
                <th>Tutar</th>
                <th>Tür</th>
                <th>Açıklama</th>
                <th>Müşteri</th>
            </tr>
        </tfoot>
    </table>
<?php } ?>

<?php 
if(isset($_GET['product'])) { 
}
?>

<?php if(isset($_GET['product'])){ ?>
<script type="text/javascript">
$(document).ready(function() {
    $('#product').DataTable({
      dom: 'Bfrtip',
      "buttons": [
        'copy',
        'excel',
        'pdf',
        'print',
      ]
    });
  });

</script> 
    <table id="product" class="display" style="width:100%">
        <thead style="background-color:#0047ab;color:white;">
            <tr>
                <th>ID</th>
                <th>Kategori</th>
                <th>Ürün</th>
                <th>Açıklama</th>
                <th>Barkod</th>
                <th>Fiyat</th>
                <th>Stok</th>
            </tr>
        </thead>
        <tbody>
        <?php 
        $products = $DB->query("SELECT * FROM products ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC); 
        foreach ($products as $productData) {       
            $categoryID = $productData['category'];
            $category = $DB->query("SELECT * FROM category WHERE id = '$categoryID'")->fetch(PDO::FETCH_ASSOC);
        ?>
            <tr>
                <td><?=$productData['id']?></td>
                <td><?=$category['ad']?></td>
                <td><?=$productData['ad']?></td>
                <td><?=$productData['productDesc']?></td>
                <td><?=$productData['productBarkod']?></td>
                <td><?=$productData['Fiyat']?>₺</td>
                <td><?=$productData['stock']?></td>
            </tr>
        <?php 
        }
        ?> 
        </tbody>
        <tfoot style="background-color:#0047ab;color:white;">
            <tr>
                <th>ID</th>
                <th>Kategori</th>
                <th>Ürün</th>
                <th>Açıklama</th>
                <th>Barkod</th>
                <th>Fiyat</th>
                <th>Stok</th>
            </tr>
        </tfoot>
    </table>
<?php } ?>

<?php 
if(isset($_GET['member'])) { 
}
?>

<?php if(isset($_GET['member'])){ ?>
<script type="text/javascript">
$(document).ready(function() {
    $('#member').DataTable({
      dom: 'Bfrtip',
      "buttons": [
        'copy',
        'excel',
        'pdf',
        'print',
      ]
    });
  });

</script> 
    <table id="member" class="display" style="width:100%">
        <thead style="background-color:#0047ab;color:white;">
            <tr>
                <th>ID</th>
                <th>Ad</th>
                <th>Telefon</th>
                <th>E-posta</th>
                <th>Adres</th>
            </tr>
        </thead>
        <tbody>
        <?php 
        $members = $DB->query("SELECT * FROM members ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC); 
        foreach ($members as $memberData) {       
        ?>
            <tr>
                <td><?=$memberData['id']?></td>
                <td><?=$memberData['name']?></td>
                <td><?=$memberData['phone']?></td>
                <td><?=$memberData['email']?></td>
                <td><?=$memberData['address']?></td>
            </tr>
        <?php 
        }
        ?> 
        </tbody>
        <tfoot style="background-color:#0047ab;color:white;">
            <tr>
                <th>ID</th>
                <th>Ad</th>
                <th>Telefon</th>
                <th>E-posta</th>
                <th>Adres</th>
            </tr>
        </tfoot>
    </table>
<?php } ?>

<?php 
if(isset($_GET['company'])) { 
}
?>

<?php if(isset($_GET['company'])){ ?>
<script type="text/javascript">
$(document).ready(function() {
    $('#company').DataTable({
      dom: 'Bfrtip',
      "buttons": [
        'copy',
        'excel',
        'pdf',
        'print',
      ]
    });
  });

</script> 
    <table id="company" class="display" style="width:100%">
        <thead style="background-color:#0047ab;color:white;">
            <tr>
                <th>ID</th>
                <th>Firma</th>
                <th>İsim</th>
                <th>Telefon</th>
                <th>E-posta</th>
                <th>Adres</th>
                <th>Son Güncelleme Tarihi</th>
                <th>Oluştuma Tarihi</th>
            </tr>
        </thead>
        <tbody>
        <?php 
        $companies = $DB->query("SELECT * FROM companies ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC); 
        foreach ($companies as $companyData) {       
        ?>
            <tr>
                <td><?=$companyData['id']?></td>
                <td><?=$companyData['company']?></td>
                <td><?=$companyData['name']?></td>
                <td><?=$companyData['phone']?></td>
                <td><?=$companyData['email']?></td>
                <td><?=$companyData['address']?></td>
                <td>
                    <?php
                    if ($companyData['date2'] != '0000-00-00') {
                        echo $companyData['date2'];
                    }
                    ?>
                </td>
                <td><?=$companyData['date']?></td>
            </tr>
        <?php 
        }
        ?> 
        </tbody>
        <tfoot style="background-color:#0047ab;color:white;">
            <tr>
            <th>ID</th>
                <th>Firma</th>
                <th>İsim</th>
                <th>Telefon</th>
                <th>E-posta</th>
                <th>Adres</th>
                <th>Son Güncelleme Tarihi</th>
                <th>Oluştuma Tarihi</th>
            </tr>
        </tfoot>
    </table>
<?php } ?>

<?php 
if(isset($_GET['provider'])) { 
}
?>

<?php if(isset($_GET['provider'])){ ?>
<script type="text/javascript">
$(document).ready(function() {
    $('#provider').DataTable({
      dom: 'Bfrtip',
      "buttons": [
        'copy',
        'excel',
        'pdf',
        'print',
      ]
    });
  });

</script> 
    <table id="provider" class="display" style="width:100%">
        <thead style="background-color:#0047ab;color:white;">
            <tr>
                <th>ID</th>
                <th>Personel Adı</th>
                <th>Pozisyon</th>
                <th>Telefon</th>
                <th>Email</th>
                <th>Durum</th>
            </tr>
        </thead>
        <tbody>
        <?php 
        $providers = $DB->query("SELECT * FROM providers WHERE status = 1 ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC); 
        foreach ($providers as $providerData) {       
        ?>
            <tr>
                <td><?=$providerData['id']?></td>
                <td><?=$providerData['name']?></td>
                <td><?=$providerData['position']?></td>
                <td>
                    <a href="tel:<?=$providerData['phone']?>"><?=$providerData['phone']?></a> 
                </td>
                <td><a href="mailto:<?=$providerData['email']?>"><?=$providerData['email']?></a></td>
                <td>
    <?php
    if ($providerData['status'] == 1) {
        echo 'Aktif';
    } elseif ($providerData['status'] == 0) {
        echo 'Deaktif';
    } 
    ?>
</td>

            </tr>
        <?php 
        }
        ?> 
        </tbody>
        <tfoot style="background-color:#0047ab;color:white;">
            <tr>
            <th>ID</th>
                <th>Personel Adı</th>
                <th>Pozisyon</th>
                <th>Telefon</th>
                <th>Email</th>
                <th>Durum</th>
            </tr>
        </tfoot>
    </table>
<?php } ?>

<?php 
if(isset($_GET['user'])) { 
}
?>

<?php if(isset($_GET['user'])){ ?>
<script type="text/javascript">
$(document).ready(function() {
    $('#user').DataTable({
      dom: 'Bfrtip',
      "buttons": [
        'copy',
        'excel',
        'pdf',
        'print',
      ]
    });
  });

</script> 
    <table id="user" class="display" style="width:100%">
        <thead style="background-color:#0047ab;color:white;">
            <tr>
                <th>ID</th>
                <th>Departman</th>
                <th>Ad</th>
                <th>E-posta</th>
            </tr>
        </thead>
        <tbody>
        <?php 
        $users = $DB->query("SELECT * FROM users ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC); 
        foreach ($users as $userData) {       
        ?>
            <tr>
                <td><?=$userData['id']?></td>
                <td>
                    <?php
                    if (isset($userData['department']) && $userData['department']) {
                        $departmentId = $userData['department'];
                        
                        $stmt = $DB->prepare("SELECT name FROM departments WHERE id = ?");
                        $stmt->execute([$departmentId]);
                        $department = $stmt->fetch(PDO::FETCH_ASSOC);
                        
                        if ($department && isset($department['name'])) {
                            echo $department['name'];
                        } else {
                            echo 'Departman Bulunamadı';
                        }
                    } else {
                        echo 'Departman Kaydı Bulunamadı';
                    }
                    ?>
                </td>
                <td><?=$userData['name']?></td>
                <td><?=$userData['email']?></td>
            </tr>
        <?php 
        }
        ?> 
        </tbody>
        <tfoot style="background-color:#0047ab;color:white;">
            <tr>
                <th>ID</th>
                <th>Departman</th>
                <th>Ad</th>
                <th>E-posta</th>
            </tr>
        </tfoot>
    </table>
<?php } ?>


